<?php
	require "config.php";

	if (!isset($_COOKIE['id'])) {
		header("Location: reglog.php");
		exit;
	}

	// LEKÉRDEZÉS
	$talalt_rendezvenyek = $conn->query("
		SELECT id, title, description, image_path, year, month, day, hour, minute FROM events ORDER BY year, month, day, hour, minute
	");

	$kartya_lista = "";

	if ($talalt_rendezvenyek && $talalt_rendezvenyek->num_rows > 0) {
		
		while ($rendezveny = $talalt_rendezvenyek->fetch_assoc()) {
		$azonosito = $rendezveny['id'];
		$cim       = $rendezveny['title'];
		$leiras    = $rendezveny['description'];
		$kep       = $rendezveny['image_path'] ?: "uploads/events/placeholder.jpg";
		
		// Dátum
		$ido = new DateTime();
		$ido->setDate($rendezveny['year'], $rendezveny['month'], $rendezveny['day']);
		$ido->setTime($rendezveny['hour'], $rendezveny['minute']);
		$datum = $ido->format("Y.m.d H:i");

		// HTML
		$kartya_lista .= "
		<article class='product-card card'>
		<a class='product-title' href='rendezveny.php?id=$azonosito'>$cim</a>
			<div class='product-thumb'>
			<img src='$kep' alt='$cim'>
		</div>
		<div class='product-info'>
			<div class='product-meta'><span class='label'>Dátum:</span> $datum</div>
			<p>$leiras</p>
		</div>
		</article>";
	}
} 
	else {
		$kartya_lista = "<div class='card search-text'>Nincs elérhető rendezvény.</div>";
	}
?>
	<!DOCTYPE html>
	<html lang="hu">
	<head>
	<meta charset="UTF-8">
	<title>Események</title>
	<link rel="stylesheet" href="css/styles.css">
	</head>
	<body>

	<?php include "nav.php"; ?>

	<main class="content">
		<h1>Rendezvények</h1>
		<div id="list" class="product-grid">
		<?= $kartya_lista ?>
		</div>
	</main>

	</body>
</html>

